/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.Host;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class UserPreferences {
    private static final String FILENAME = "AppleCommander.preferences";
    private static final String IMAGE_DIRECTORY = "imageDirectory";
    private static final String EXPORT_DIRECTORY = "exportDirectory";
    private static final String COMPILE_DIRECTORY = "compileDirectory";
    private static final String SAVE_DIRECTORY = "saveDirectory";
    private static final String IMPORT_DIRECTORY = "importDirectory";
    private static UserPreferences instance;
    private Properties properties = new Properties();

    private UserPreferences() {
    }

    public static UserPreferences getInstance() {
        if (instance == null) {
            instance = new UserPreferences();
            instance.load();
        }
        return instance;
    }

    private void load() {
        try {
            FileInputStream inputStream = new FileInputStream(Host.getPrefDir() + FILENAME);
            this.properties.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        try {
            FileOutputStream outputStream = new FileOutputStream(Host.getPrefDir() + FILENAME);
            this.properties.store(outputStream, UiBundle.getInstance().get("UserPreferencesComment"));
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDiskImageDirectory() {
        return this.properties.getProperty(IMAGE_DIRECTORY);
    }

    public String getExportDirectory() {
        return this.properties.getProperty(EXPORT_DIRECTORY);
    }

    public String getCompileDirectory() {
        return this.properties.getProperty(COMPILE_DIRECTORY);
    }

    public String getSaveDirectory() {
        return this.properties.getProperty(SAVE_DIRECTORY);
    }

    public String getImportDirectory() {
        return this.properties.getProperty(IMPORT_DIRECTORY);
    }

    public void setDiskImageDirectory(String diskImageDirectory) {
        this.properties.setProperty(IMAGE_DIRECTORY, diskImageDirectory);
    }

    public void setExportDirectory(String exportDirectory) {
        this.properties.setProperty(EXPORT_DIRECTORY, exportDirectory);
    }

    public void setCompileDirectory(String compileDirectory) {
        this.properties.setProperty(COMPILE_DIRECTORY, compileDirectory);
    }

    public void setSaveDirectory(String saveDirectory) {
        this.properties.setProperty(SAVE_DIRECTORY, saveDirectory);
    }

    public void setImportDirectory(String importDirectory) {
        this.properties.setProperty(IMPORT_DIRECTORY, importDirectory);
    }
}

